/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.directory;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;

public class BasicAttribute
implements Attribute {
    protected String attrID;
    protected transient Vector values;
    protected boolean ordered = false;
    private static final long serialVersionUID = 6743528196119291326L;

    public int hashCode() {
        int n2 = this.attrID.hashCode();
        int n3 = this.values.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            Object object = this.values.elementAt(i2);
            if (object == null) continue;
            if (object.getClass().isArray()) {
                int n4 = Array.getLength(object);
                for (int i3 = 0; i3 < n4; ++i3) {
                    Object object2 = Array.get(object, i3);
                    if (object2 == null) continue;
                    n2 += object2.hashCode();
                }
                continue;
            }
            n2 += object.hashCode();
        }
        return n2;
    }

    public int size() {
        return this.values.size();
    }

    public void clear() {
        this.values.setSize(0);
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        this.values = new Vector(n2);
        while (--n2 >= 0) {
            this.values.addElement(objectInputStream.readObject());
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.values.size());
        for (int i2 = 0; i2 < this.values.size(); ++i2) {
            objectOutputStream.writeObject(this.values.elementAt(i2));
        }
    }

    public Object clone() {
        BasicAttribute basicAttribute;
        try {
            basicAttribute = (BasicAttribute)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            basicAttribute = new BasicAttribute(this.attrID, this.ordered);
        }
        basicAttribute.values = (Vector)this.values.clone();
        return basicAttribute;
    }

    public Object get() throws NamingException {
        if (this.values.size() == 0) {
            throw new NoSuchElementException("Attribute " + this.getID() + " has no value");
        }
        return this.values.elementAt(0);
    }

    public Object get(int n2) throws NamingException {
        return this.values.elementAt(n2);
    }

    public Object remove(int n2) {
        Object object = this.values.elementAt(n2);
        this.values.removeElementAt(n2);
        return object;
    }

    public void add(int n2, Object object) {
        if (!this.isOrdered() && this.contains(object)) {
            throw new IllegalStateException("Cannot add duplicate to unordered attribute");
        }
        this.values.insertElementAt(object, n2);
    }

    private int find(Object object) {
        if (object == null) {
            int n2 = this.values.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.values.elementAt(i2) != null) continue;
                return i2;
            }
        } else {
            Class clazz = object.getClass();
            if (clazz.isArray()) {
                int n3 = this.values.size();
                for (int i3 = 0; i3 < n3; ++i3) {
                    Object object2 = this.values.elementAt(i3);
                    if (object2 == null || clazz != object2.getClass() || !BasicAttribute.arrayEquals(object, object2)) continue;
                    return i3;
                }
            } else {
                return this.values.indexOf(object, 0);
            }
        }
        return -1;
    }

    public boolean add(Object object) {
        if (this.isOrdered() || this.find(object) < 0) {
            this.values.addElement(object);
            return true;
        }
        return false;
    }

    public boolean contains(Object object) {
        return this.find(object) >= 0;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Attribute) {
            int n2;
            Attribute attribute = (Attribute)object;
            if (this.isOrdered() != attribute.isOrdered()) {
                return false;
            }
            if (this.attrID.equals(attribute.getID()) && (n2 = this.size()) == attribute.size()) {
                try {
                    if (this.isOrdered()) {
                        for (int i2 = 0; i2 < n2; ++i2) {
                            if (BasicAttribute.valueEquals(this.get(i2), attribute.get(i2))) continue;
                            return false;
                        }
                    } else {
                        NamingEnumeration namingEnumeration = attribute.getAll();
                        while (namingEnumeration.hasMoreElements()) {
                            if (this.find(namingEnumeration.nextElement()) >= 0) continue;
                            return false;
                        }
                    }
                }
                catch (NamingException namingException) {
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public boolean remove(Object object) {
        int n2 = this.find(object);
        if (n2 >= 0) {
            this.values.removeElementAt(n2);
            return true;
        }
        return false;
    }

    public String getID() {
        return this.attrID;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.attrID + ": ");
        if (this.values.size() == 0) {
            stringBuffer.append("No values");
        } else {
            boolean bl2 = true;
            Enumeration enumeration = this.values.elements();
            while (enumeration.hasMoreElements()) {
                if (!bl2) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(enumeration.nextElement());
                bl2 = false;
            }
        }
        return stringBuffer.toString();
    }

    public BasicAttribute(String string) {
        this(string, false);
    }

    public BasicAttribute(String string, boolean bl2) {
        this.attrID = string;
        this.values = new Vector();
        this.ordered = bl2;
    }

    public NamingEnumeration getAll() throws NamingException {
        return new ValuesEnumImpl(this);
    }

    public DirContext getAttributeDefinition() throws NamingException {
        throw new OperationNotSupportedException("attribute definition");
    }

    public DirContext getAttributeSyntaxDefinition() throws NamingException {
        throw new OperationNotSupportedException("attribute syntax");
    }

    public Object set(int n2, Object object) {
        if (!this.isOrdered() && this.contains(object)) {
            throw new IllegalStateException("Cannot add duplicate to unordered attribute");
        }
        Object object2 = this.values.elementAt(n2);
        this.values.setElementAt(object, n2);
        return object2;
    }

    private static boolean arrayEquals(Object object, Object object2) {
        int n2 = Array.getLength(object);
        if (n2 != Array.getLength(object2)) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object3 = Array.get(object, i2);
            Object object4 = Array.get(object2, i2);
            if (!(object3 == null || object4 == null ? object3 != object4 : !object3.equals(object4))) continue;
            return false;
        }
        return true;
    }

    private static boolean valueEquals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass().isArray() && object2.getClass().isArray()) {
            return BasicAttribute.arrayEquals(object, object2);
        }
        return object.equals(object2);
    }

    public BasicAttribute(String string, Object object) {
        this(string, object, false);
    }

    public BasicAttribute(String string, Object object, boolean bl2) {
        this(string, bl2);
        this.values.addElement(object);
    }

    class ValuesEnumImpl
    implements NamingEnumeration {
        Enumeration list;
        private final BasicAttribute this$0;

        public void close() throws NamingException {
            this.list = null;
        }

        public boolean hasMore() throws NamingException {
            return this.list.hasMoreElements();
        }

        public boolean hasMoreElements() {
            return this.list.hasMoreElements();
        }

        public Object next() throws NamingException {
            return this.list.nextElement();
        }

        public Object nextElement() {
            return this.list.nextElement();
        }

        ValuesEnumImpl(BasicAttribute basicAttribute) {
            this.this$0 = basicAttribute;
            this.list = basicAttribute.values.elements();
        }
    }
}

